/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWException;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWTextAnnotationListCellRenderer
extends JLabel
implements ListCellRenderer {
    public VWTextAnnotationListCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list != null && value != null) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof VWTextAnnotationDefinition) {
                try {
                    this.setText(VWTextAnnotationListCellRenderer.toString((VWTextAnnotationDefinition)value));
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    this.setText(VWResource.s_blankTextAnnotationLabel.toString(""));
                }
            }
        } else {
            this.setText(null);
        }
        return this;
    }

    public static String toString(VWTextAnnotationDefinition textAnnotationDef) throws VWException {
        String name = textAnnotationDef.getName();
        if (name == null) {
            name = VWTextAnnotationListCellRenderer.getBlankName(textAnnotationDef);
        }
        return name;
    }

    public static String getBlankName(VWTextAnnotationDefinition textAnnotationDef) throws VWException {
        int nId = textAnnotationDef.getId() + 1;
        return VWResource.s_blankTextAnnotationLabel.toString(Integer.toString(nId));
    }
}

